/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.CachedGetPropertyNode;
import com.oracle.truffle.js.nodes.access.CachedSetPropertyNode;
import com.oracle.truffle.js.nodes.access.FrequencyBasedPolymorphicAccessNode;
import com.oracle.truffle.js.nodes.access.JSProxyPropertySetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=CachedSetPropertyNode.class)
final class CachedSetPropertyNodeGen
extends CachedSetPropertyNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private CachedKeyData cachedKey_cache;
    @CompilerDirectives.CompilationFinal
    private JSClassProfile intIndex_jsclassProfile_;
    @Node.Child
    private ArrayIndexData arrayIndex_cache;
    @Node.Child
    private JSProxyPropertySetNode proxy_proxySet_;
    @Node.Child
    private GenericData generic_cache;

    private CachedSetPropertyNodeGen(JSContext context, boolean strict, boolean setOwn, boolean superProperty) {
        super(context, strict, setOwn, superProperty);
    }

    @Override
    @ExplodeLoop
    public void execute(DynamicObject arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            int arg1Value_;
            if ((state_0 & 1) != 0) {
                CachedKeyData s1_ = this.cachedKey_cache;
                while (s1_ != null) {
                    assert (s1_.cachedKey_ != null);
                    assert (!JSRuntime.isArrayIndex(s1_.cachedKey_));
                    if (JSRuntime.propertyKeyEquals(s1_.cachedKey_, arg1Value)) {
                        this.doCachedKey(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedKey_, s1_.propertyNode_);
                        return;
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0 && arg1Value instanceof Integer && JSRuntime.isArrayIndex(arg1Value_ = ((Integer)arg1Value).intValue()) && !JSGuards.isJSProxy(arg0Value)) {
                this.doIntIndex(arg0Value, arg1Value_, arg2Value, arg3Value, this.intIndex_jsclassProfile_);
                return;
            }
            if ((state_0 & 0x1C) != 0) {
                GenericData s5_;
                if ((state_0 & 4) != 0 && !JSGuards.isJSProxy(arg0Value)) {
                    ArrayIndexData s3_ = this.arrayIndex_cache;
                    while (s3_ != null) {
                        Object maybeIndex__ = s3_.toArrayIndexNode_.execute(arg1Value);
                        if (s3_.toArrayIndexNode_.isResultArrayIndex(maybeIndex__)) {
                            this.doArrayIndex(arg0Value, arg1Value, arg2Value, arg3Value, s3_.toArrayIndexNode_, maybeIndex__, s3_.jsclassProfile_);
                            return;
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 8) != 0 && JSGuards.isJSProxy(arg0Value)) {
                    this.doProxy(arg0Value, arg1Value, arg2Value, arg3Value, this.proxy_proxySet_);
                    return;
                }
                if ((state_0 & 0x10) != 0 && (s5_ = this.generic_cache) != null) {
                    this.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, s5_.toArrayIndexNode_, s5_.getType_, s5_.jsclassProfile_, s5_.highFrequency_, s5_.hotKey_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(DynamicObject arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        int oldState_0 = state_0;
        try {
            int arg1Value_;
            if ((exclude & 1) == 0) {
                Object cachedKey__;
                int count1_ = 0;
                CachedKeyData s1_ = this.cachedKey_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null) {
                        assert (s1_.cachedKey_ != null);
                        assert (!JSRuntime.isArrayIndex(s1_.cachedKey_));
                        if (JSRuntime.propertyKeyEquals(s1_.cachedKey_, arg1Value)) break;
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedKey__ = CachedGetPropertyNode.cachedPropertyKey(arg1Value)) != null && !JSRuntime.isArrayIndex(cachedKey__) && JSRuntime.propertyKeyEquals(cachedKey__, arg1Value) && count1_ < 1) {
                    s1_ = (CachedKeyData)super.insert((Node)new CachedKeyData(this.cachedKey_cache));
                    s1_.cachedKey_ = cachedKey__;
                    s1_.propertyNode_ = s1_.insertAccessor(this.createSet(cachedKey__));
                    this.cachedKey_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doCachedKey(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedKey_, s1_.propertyNode_);
                    return;
                }
            }
            if ((exclude & 2) == 0 && arg1Value instanceof Integer && JSRuntime.isArrayIndex(arg1Value_ = ((Integer)arg1Value).intValue()) && !JSGuards.isJSProxy(arg0Value)) {
                this.intIndex_jsclassProfile_ = JSClassProfile.create();
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                this.doIntIndex(arg0Value, arg1Value_, arg2Value, arg3Value, this.intIndex_jsclassProfile_);
                return;
            }
            Object maybeIndex__ = null;
            if ((exclude & 4) == 0 && !JSGuards.isJSProxy(arg0Value)) {
                ToArrayIndexNode toArrayIndexNode__;
                int count3_ = 0;
                ArrayIndexData s3_ = this.arrayIndex_cache;
                if ((state_0 & 4) != 0) {
                    while (s3_ != null && !s3_.toArrayIndexNode_.isResultArrayIndex(maybeIndex__ = s3_.toArrayIndexNode_.execute(arg1Value))) {
                        s3_ = s3_.next_;
                        ++count3_;
                    }
                }
                if (s3_ == null && (toArrayIndexNode__ = (ToArrayIndexNode)super.insert((Node)ToArrayIndexNode.createNoToPropertyKey())).isResultArrayIndex(maybeIndex__ = toArrayIndexNode__.execute(arg1Value)) && count3_ < 3) {
                    s3_ = (ArrayIndexData)super.insert((Node)new ArrayIndexData(this.arrayIndex_cache));
                    s3_.toArrayIndexNode_ = s3_.insertAccessor(toArrayIndexNode__);
                    s3_.jsclassProfile_ = JSClassProfile.create();
                    this.arrayIndex_cache = s3_;
                    this.exclude_ = exclude |= 2;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doArrayIndex(arg0Value, arg1Value, arg2Value, arg3Value, s3_.toArrayIndexNode_, maybeIndex__, s3_.jsclassProfile_);
                    return;
                }
            }
            if ((exclude & 8) == 0 && JSGuards.isJSProxy(arg0Value)) {
                this.proxy_proxySet_ = (JSProxyPropertySetNode)super.insert((Node)JSProxyPropertySetNode.create(this.context, this.strict));
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                this.doProxy(arg0Value, arg1Value, arg2Value, arg3Value, this.proxy_proxySet_);
                return;
            }
            GenericData s5_ = (GenericData)super.insert((Node)new GenericData());
            s5_.toArrayIndexNode_ = s5_.insertAccessor(ToArrayIndexNode.create());
            s5_.getType_ = ConditionProfile.createBinaryProfile();
            s5_.jsclassProfile_ = JSClassProfile.create();
            s5_.highFrequency_ = ConditionProfile.createBinaryProfile();
            s5_.hotKey_ = s5_.insertAccessor(FrequencyBasedPolymorphicAccessNode.createFrequencyBasedPropertySet(this.context, this.setOwn, this.strict, this.superProperty));
            this.generic_cache = s5_;
            this.exclude_ = exclude |= 0xF;
            this.cachedKey_cache = null;
            this.arrayIndex_cache = null;
            state_0 &= 0xFFFFFFF0;
            this.state_0_ = state_0 |= 0x10;
            lock.unlock();
            hasLock = false;
            this.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, s5_.toArrayIndexNode_, s5_.getType_, s5_.jsclassProfile_, s5_.highFrequency_, s5_.hotKey_);
            return;
        }
        finally {
            if (oldState_0 != 0) {
                this.checkForPolymorphicSpecialize(oldState_0);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState_0) {
        if ((oldState_0 & 0x10) == 0 && (this.state_0_ & 0x10) != 0) {
            this.reportPolymorphicSpecialize();
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            CachedKeyData s1_ = this.cachedKey_cache;
            ArrayIndexData s3_ = this.arrayIndex_cache;
            if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCachedKey";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            CachedKeyData s1_ = this.cachedKey_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(new Object[]{s1_.cachedKey_, s1_.propertyNode_}));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doIntIndex";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.intIndex_jsclassProfile_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doArrayIndex";
        if ((state_0 & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ArrayIndexData s3_ = this.arrayIndex_cache;
            while (s3_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s3_.toArrayIndexNode_, s3_.jsclassProfile_}));
                s3_ = s3_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doProxy";
        if ((state_0 & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.proxy_proxySet_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state_0 & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            GenericData s5_ = this.generic_cache;
            if (s5_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s5_.toArrayIndexNode_, s5_.getType_, s5_.jsclassProfile_, s5_.highFrequency_, s5_.hotKey_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static CachedSetPropertyNode create(JSContext context, boolean strict, boolean setOwn, boolean superProperty) {
        return new CachedSetPropertyNodeGen(context, strict, setOwn, superProperty);
    }

    @GeneratedBy(value=CachedSetPropertyNode.class)
    private static final class GenericData
    extends Node {
        @Node.Child
        ToArrayIndexNode toArrayIndexNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile getType_;
        @CompilerDirectives.CompilationFinal
        JSClassProfile jsclassProfile_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile highFrequency_;
        @Node.Child
        FrequencyBasedPolymorphicAccessNode.FrequencyBasedPropertySetNode hotKey_;

        GenericData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=CachedSetPropertyNode.class)
    private static final class ArrayIndexData
    extends Node {
        @Node.Child
        ArrayIndexData next_;
        @Node.Child
        ToArrayIndexNode toArrayIndexNode_;
        @CompilerDirectives.CompilationFinal
        JSClassProfile jsclassProfile_;

        ArrayIndexData(ArrayIndexData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=CachedSetPropertyNode.class)
    private static final class CachedKeyData
    extends Node {
        @Node.Child
        CachedKeyData next_;
        @CompilerDirectives.CompilationFinal
        Object cachedKey_;
        @Node.Child
        PropertySetNode propertyNode_;

        CachedKeyData(CachedKeyData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

